/******************************************************************************
 *
 * Copyright (c) 2003-2004 PalmSource, Inc. or its subsidiaries.
 *
 * File: CharKR.h
 *
 * Release: 
 *
 * Description:
 *         	Header file for EUC-KR (Korean) coded character set.
 *
 * History:
 *	2003-10-14	KKr	Created by Ken Krugler.
 *	2003-10-16	KKr	Fixed 0x5C (should be a Won).
 *	2003-12-18	CS	Added wrapping info extended attributes.
 *	2003-12-30	KKr	Filled out full set of auto-generated character names.
 *	2004-01-03	KKr	Removed all xxxHangulxxx names, as these aren't very useful.
 *					Also fixed _SQUARE_ -> Square and _CIRCLE_ -> Circle.
 *					Fixed up _APOSTROPHE -> Apostrophe.
 *	2004-01-03	CS	Changed kKRLastHighByte from 0xFD to 0xFE.  Although this
 *					high byte is not currently used for anything, we still
 *					consider it valid for the encoding.
 *
 *****************************************************************************/

#ifndef _CHARKR_H_
#define _CHARKR_H_

/***********************************************************************
 * Public macros
 ***********************************************************************/

/***********************************************************************
 * Public constants
 ***********************************************************************/

// Transliteration operations that are not universal, but can be applied
// to Korean text (none yet).

// Extended character attributes for the EUC-KR character set.
// Note that these attributes have to be on an encoding basis, since
// they're shared across all languages which use this encoding. For
// KR there's only one language, so we're OK to encode wrapping
// info here, which is often language-dependent.

#define	charXAttrKRMask									0x00FF
#define	charXAttrKRFollowing							0x0001
#define	charXAttrKRLeading								0x0002
#define	charXAttrKRBreak								0x0004

// Note that these values, as well as the first/last double byte
// constants defined below, are for a superset of EUC-KR.
#define kKRFirstHighByte								0x81
#define kKRLastHighByte									0xFE
#define kKRFirstLowByte									0x41
#define kKRLastLowByte									0xFE

// Character codes that are specific to EUC-KR. These names
// are generated from the Unicode 3.1 data files.

#define	chrKRWonSign									0x005c

#define	chrKRFirstDoubleByte							0x8141

#define	chrKRIdeographicSpace								0xa1a1
#define	chrKRIdeographicComma								0xa1a2
#define	chrKRIdeographicFullStop							0xa1a3
#define	chrKRMiddleDot										0xa1a4
#define	chrKRTwoDotLeader									0xa1a5
#define	chrKRHorizontalEllipsis								0xa1a6
#define	chrKRDiaeresis										0xa1a7
#define	chrKRDittoMark										0xa1a8
#define	chrKRSoftHyphen										0xa1a9
#define	chrKRHorizontalBar									0xa1aa
#define	chrKRParallelTo										0xa1ab
#define	chrKRFullwidthReverseSolidus						0xa1ac
#define	chrKRTildeOperator									0xa1ad
#define	chrKRLeftSingleQuotationMark						0xa1ae
#define	chrKRRightSingleQuotationMark						0xa1af
#define	chrKRLeftDoubleQuotationMark						0xa1b0
#define	chrKRRightDoubleQuotationMark						0xa1b1
#define	chrKRLeftTortoiseShellBracket						0xa1b2
#define	chrKRRightTortoiseShellBracket						0xa1b3
#define	chrKRLeftAngleBracket								0xa1b4
#define	chrKRRightAngleBracket								0xa1b5
#define	chrKRLeftDoubleAngleBracket							0xa1b6
#define	chrKRRightDoubleAngleBracket						0xa1b7
#define	chrKRLeftCornerBracket								0xa1b8
#define	chrKRRightCornerBracket								0xa1b9
#define	chrKRLeftWhiteCornerBracket							0xa1ba
#define	chrKRRightWhiteCornerBracket						0xa1bb
#define	chrKRLeftBlackLenticularBracket						0xa1bc
#define	chrKRRightBlackLenticularBracket					0xa1bd
#define	chrKRPlusMinusSign									0xa1be
#define	chrKRMultiplicationSign								0xa1bf
#define	chrKRDivisionSign									0xa1c0
#define	chrKRNotEqualTo										0xa1c1
#define	chrKRLessThanOrEqualTo								0xa1c2
#define	chrKRGreaterThanOrEqualTo							0xa1c3
#define	chrKRInfinity										0xa1c4
#define	chrKRTherefore										0xa1c5
#define	chrKRDegreeSign										0xa1c6
#define	chrKRPrime											0xa1c7
#define	chrKRDoublePrime									0xa1c8
#define	chrKRDegreeCelsius									0xa1c9
#define	chrKRAngstromSign									0xa1ca
#define	chrKRFullwidthCentSign								0xa1cb
#define	chrKRFullwidthPoundSign								0xa1cc
#define	chrKRFullwidthYenSign								0xa1cd
#define	chrKRMaleSign										0xa1ce
#define	chrKRFemaleSign										0xa1cf
#define	chrKRAngle											0xa1d0
#define	chrKRUpTack											0xa1d1
#define	chrKRArc											0xa1d2
#define	chrKRPartialDifferential							0xa1d3
#define	chrKRNabla											0xa1d4
#define	chrKRIdenticalTo									0xa1d5
#define	chrKRApproximatelyEqualToOrTheImageOf				0xa1d6
#define	chrKRSectionSign									0xa1d7
#define	chrKRReferenceMark									0xa1d8
#define	chrKRWhiteStar										0xa1d9
#define	chrKRBlackStar										0xa1da
#define	chrKRWhiteCircle									0xa1db
#define	chrKRBlackCircle									0xa1dc
#define	chrKRBullseye										0xa1dd
#define	chrKRWhiteDiamond									0xa1de
#define	chrKRBlackDiamond									0xa1df
#define	chrKRWhiteSquare									0xa1e0
#define	chrKRBlackSquare									0xa1e1
#define	chrKRWhiteUpPointingTriangle						0xa1e2
#define	chrKRBlackUpPointingTriangle						0xa1e3
#define	chrKRWhiteDownPointingTriangle						0xa1e4
#define	chrKRBlackDownPointingTriangle						0xa1e5
#define	chrKRRightwardsArrow								0xa1e6
#define	chrKRLeftwardsArrow									0xa1e7
#define	chrKRUpwardsArrow									0xa1e8
#define	chrKRDownwardsArrow									0xa1e9
#define	chrKRLeftRightArrow									0xa1ea
#define	chrKRGetaMark										0xa1eb
#define	chrKRMuchLessThan									0xa1ec
#define	chrKRMuchGreaterThan								0xa1ed
#define	chrKRSquareRoot										0xa1ee
#define	chrKRReversedTilde									0xa1ef
#define	chrKRProportionalTo									0xa1f0
#define	chrKRBecause										0xa1f1
#define	chrKRIntegral										0xa1f2
#define	chrKRDoubleIntegral									0xa1f3
#define	chrKRElementOf										0xa1f4
#define	chrKRContainsAsMember								0xa1f5
#define	chrKRSubsetOfOrEqualTo								0xa1f6
#define	chrKRSupersetOfOrEqualTo							0xa1f7
#define	chrKRSubsetOf										0xa1f8
#define	chrKRSupersetOf										0xa1f9
#define	chrKRUnion											0xa1fa
#define	chrKRIntersection									0xa1fb
#define	chrKRLogicalAnd										0xa1fc
#define	chrKRLogicalOr										0xa1fd
#define	chrKRFullwidthNotSign								0xa1fe
#define	chrKRRightwardsDoubleArrow							0xa2a1
#define	chrKRLeftRightDoubleArrow							0xa2a2
#define	chrKRForAll											0xa2a3
#define	chrKRThereExists									0xa2a4
#define	chrKRAcuteAccent									0xa2a5
#define	chrKRFullwidthTilde									0xa2a6
#define	chrKRCaron											0xa2a7
#define	chrKRBreve											0xa2a8
#define	chrKRDoubleAcuteAccent								0xa2a9
#define	chrKRRingAbove										0xa2aa
#define	chrKRDotAbove										0xa2ab
#define	chrKRCedilla										0xa2ac
#define	chrKROgonek											0xa2ad
#define	chrKRInvertedExclamationMark						0xa2ae
#define	chrKRInvertedQuestionMark							0xa2af
#define	chrKRModifierTriangular_COLON						0xa2b0
#define	chrKRContourIntegral								0xa2b1
#define	chrKRNArySummation									0xa2b2
#define	chrKRNAryProduct									0xa2b3
#define	chrKRCurrencySign									0xa2b4
#define	chrKRDegreeFahrenheit								0xa2b5
#define	chrKRPerMilleSign									0xa2b6
#define	chrKRWhiteLeftPointingTriangle						0xa2b7
#define	chrKRBlackLeftPointingTriangle						0xa2b8
#define	chrKRWhiteRightPointingTriangle						0xa2b9
#define	chrKRBlackRightPointingTriangle						0xa2ba
#define	chrKRWhiteSpadeSuit									0xa2bb
#define	chrKRBlackSpadeSuit									0xa2bc
#define	chrKRWhiteHeartSuit									0xa2bd
#define	chrKRBlackHeartSuit									0xa2be
#define	chrKRWhiteClubSuit									0xa2bf
#define	chrKRBlackClubSuit									0xa2c0
#define	chrKRCircledDotOperator								0xa2c1
#define	chrKRWhiteDiamondContainingBlackSmallDiamond		0xa2c2
#define	chrKRWhiteSquareContainingBlackSmallSquare			0xa2c3
#define	chrKRCircleLeftHalfBlack							0xa2c4
#define	chrKRCircleRightHalfBlack							0xa2c5
#define	chrKRMediumShade									0xa2c6
#define	chrKRSquareHorizontalFill							0xa2c7
#define	chrKRSquareVerticalFill								0xa2c8
#define	chrKRSquareUpperRightToLowerLeftFill				0xa2c9
#define	chrKRSquareUpperLeftToLowerRightFill				0xa2ca
#define	chrKRSquareOrthogonalCrosshatchFill					0xa2cb
#define	chrKRSquareDiagonalCrosshatchFill					0xa2cc
#define	chrKRHotSprings										0xa2cd
#define	chrKRWhiteTelephone									0xa2ce
#define	chrKRBlackTelephone									0xa2cf
#define	chrKRWhiteLeftPointingIndex							0xa2d0
#define	chrKRWhiteRightPointingIndex						0xa2d1
#define	chrKRPilcrowSign									0xa2d2
#define	chrKRDagger											0xa2d3
#define	chrKRDoubleDagger									0xa2d4
#define	chrKRUpDownArrow									0xa2d5
#define	chrKRNorthEastArrow									0xa2d6
#define	chrKRSouthWestArrow									0xa2d7
#define	chrKRNorthWestArrow									0xa2d8
#define	chrKRSouthEastArrow									0xa2d9
#define	chrKRMusicFlatSign									0xa2da
#define	chrKRQuarterNote									0xa2db
#define	chrKREighthNote										0xa2dc
#define	chrKRBeamedSixteenthNotes							0xa2dd
#define	chrKRKoreanStandardSymbol							0xa2de
#define	chrKRNumeroSign										0xa2e0
#define	chrKRSquareCo										0xa2e1
#define	chrKRTradeMarkSign									0xa2e2
#define	chrKRSquareAm										0xa2e3
#define	chrKRSquarePm										0xa2e4
#define	chrKRTelephoneSign									0xa2e5
#define	chrKREuroSign										0xa2e6
#define	chrKRRegisteredSign									0xa2e7
#define	chrKRFullwidthExclamationMark						0xa3a1
#define	chrKRFullwidthQuotationMark							0xa3a2
#define	chrKRFullwidthNumberSign							0xa3a3
#define	chrKRFullwidthDollarSign							0xa3a4
#define	chrKRFullwidthPercentSign							0xa3a5
#define	chrKRFullwidthAmpersand								0xa3a6
#define	chrKRFullwidthApostrophe							0xa3a7
#define	chrKRFullwidthLeftParenthesis						0xa3a8
#define	chrKRFullwidthRightParenthesis						0xa3a9
#define	chrKRFullwidthAsterisk								0xa3aa
#define	chrKRFullwidthPlusSign								0xa3ab
#define	chrKRFullwidthComma									0xa3ac
#define	chrKRFullwidthHyphenMinus							0xa3ad
#define	chrKRFullwidthFullStop								0xa3ae
#define	chrKRFullwidthSolidus								0xa3af
#define	chrKRFullwidthDigitZero								0xa3b0
#define	chrKRFullwidthDigitOne								0xa3b1
#define	chrKRFullwidthDigitTwo								0xa3b2
#define	chrKRFullwidthDigitThree							0xa3b3
#define	chrKRFullwidthDigitFour								0xa3b4
#define	chrKRFullwidthDigitFive								0xa3b5
#define	chrKRFullwidthDigitSix								0xa3b6
#define	chrKRFullwidthDigitSeven							0xa3b7
#define	chrKRFullwidthDigitEight							0xa3b8
#define	chrKRFullwidthDigitNine								0xa3b9
#define	chrKRFullwidthColon									0xa3ba
#define	chrKRFullwidthSemicolon								0xa3bb
#define	chrKRFullwidthLessThanSign							0xa3bc
#define	chrKRFullwidthEqualsSign							0xa3bd
#define	chrKRFullwidthGreaterThanSign						0xa3be
#define	chrKRFullwidthQuestionMark							0xa3bf
#define	chrKRFullwidthCommercialAt							0xa3c0
#define	chrKRFullwidthCapital_A								0xa3c1
#define	chrKRFullwidthCapital_B								0xa3c2
#define	chrKRFullwidthCapital_C								0xa3c3
#define	chrKRFullwidthCapital_D								0xa3c4
#define	chrKRFullwidthCapital_E								0xa3c5
#define	chrKRFullwidthCapital_F								0xa3c6
#define	chrKRFullwidthCapital_G								0xa3c7
#define	chrKRFullwidthCapital_H								0xa3c8
#define	chrKRFullwidthCapital_I								0xa3c9
#define	chrKRFullwidthCapital_J								0xa3ca
#define	chrKRFullwidthCapital_K								0xa3cb
#define	chrKRFullwidthCapital_L								0xa3cc
#define	chrKRFullwidthCapital_M								0xa3cd
#define	chrKRFullwidthCapital_N								0xa3ce
#define	chrKRFullwidthCapital_O								0xa3cf
#define	chrKRFullwidthCapital_P								0xa3d0
#define	chrKRFullwidthCapital_Q								0xa3d1
#define	chrKRFullwidthCapital_R								0xa3d2
#define	chrKRFullwidthCapital_S								0xa3d3
#define	chrKRFullwidthCapital_T								0xa3d4
#define	chrKRFullwidthCapital_U								0xa3d5
#define	chrKRFullwidthCapital_V								0xa3d6
#define	chrKRFullwidthCapital_W								0xa3d7
#define	chrKRFullwidthCapital_X								0xa3d8
#define	chrKRFullwidthCapital_Y								0xa3d9
#define	chrKRFullwidthCapital_Z								0xa3da
#define	chrKRFullwidthLeftSquareBracket						0xa3db
#define	chrKRFullwidthWonSign								0xa3dc
#define	chrKRFullwidthRightSquareBracket					0xa3dd
#define	chrKRFullwidthCircumflexAccent						0xa3de
#define	chrKRFullwidthLowLine								0xa3df
#define	chrKRFullwidthGraveAccent							0xa3e0
#define	chrKRFullwidthSmall_A								0xa3e1
#define	chrKRFullwidthSmall_B								0xa3e2
#define	chrKRFullwidthSmall_C								0xa3e3
#define	chrKRFullwidthSmall_D								0xa3e4
#define	chrKRFullwidthSmall_E								0xa3e5
#define	chrKRFullwidthSmall_F								0xa3e6
#define	chrKRFullwidthSmall_G								0xa3e7
#define	chrKRFullwidthSmall_H								0xa3e8
#define	chrKRFullwidthSmall_I								0xa3e9
#define	chrKRFullwidthSmall_J								0xa3ea
#define	chrKRFullwidthSmall_K								0xa3eb
#define	chrKRFullwidthSmall_L								0xa3ec
#define	chrKRFullwidthSmall_M								0xa3ed
#define	chrKRFullwidthSmall_N								0xa3ee
#define	chrKRFullwidthSmall_O								0xa3ef
#define	chrKRFullwidthSmall_P								0xa3f0
#define	chrKRFullwidthSmall_Q								0xa3f1
#define	chrKRFullwidthSmall_R								0xa3f2
#define	chrKRFullwidthSmall_S								0xa3f3
#define	chrKRFullwidthSmall_T								0xa3f4
#define	chrKRFullwidthSmall_U								0xa3f5
#define	chrKRFullwidthSmall_V								0xa3f6
#define	chrKRFullwidthSmall_W								0xa3f7
#define	chrKRFullwidthSmall_X								0xa3f8
#define	chrKRFullwidthSmall_Y								0xa3f9
#define	chrKRFullwidthSmall_Z								0xa3fa
#define	chrKRFullwidthLeftCurlyBracket						0xa3fb
#define	chrKRFullwidthVerticalLine							0xa3fc
#define	chrKRFullwidthRightCurlyBracket						0xa3fd
#define	chrKRFullwidthMacron								0xa3fe
#define	chrKRSmallRomanNumeralOne							0xa5a1
#define	chrKRSmallRomanNumeralTwo							0xa5a2
#define	chrKRSmallRomanNumeralThree							0xa5a3
#define	chrKRSmallRomanNumeralFour							0xa5a4
#define	chrKRSmallRomanNumeralFive							0xa5a5
#define	chrKRSmallRomanNumeralSix							0xa5a6
#define	chrKRSmallRomanNumeralSeven							0xa5a7
#define	chrKRSmallRomanNumeralEight							0xa5a8
#define	chrKRSmallRomanNumeralNine							0xa5a9
#define	chrKRSmallRomanNumeralTen							0xa5aa
#define	chrKRRomanNumeralOne								0xa5b0
#define	chrKRRomanNumeralTwo								0xa5b1
#define	chrKRRomanNumeralThree								0xa5b2
#define	chrKRRomanNumeralFour								0xa5b3
#define	chrKRRomanNumeralFive								0xa5b4
#define	chrKRRomanNumeralSix								0xa5b5
#define	chrKRRomanNumeralSeven								0xa5b6
#define	chrKRRomanNumeralEight								0xa5b7
#define	chrKRRomanNumeralNine								0xa5b8
#define	chrKRRomanNumeralTen								0xa5b9
#define	chrKRGreekCapital_ALPHA								0xa5c1
#define	chrKRGreekCapital_BETA								0xa5c2
#define	chrKRGreekCapital_GAMMA								0xa5c3
#define	chrKRGreekCapital_DELTA								0xa5c4
#define	chrKRGreekCapital_EPSILON							0xa5c5
#define	chrKRGreekCapital_ZETA								0xa5c6
#define	chrKRGreekCapital_ETA								0xa5c7
#define	chrKRGreekCapital_THETA								0xa5c8
#define	chrKRGreekCapital_IOTA								0xa5c9
#define	chrKRGreekCapital_KAPPA								0xa5ca
#define	chrKRGreekCapital_LAMDA								0xa5cb
#define	chrKRGreekCapital_MU								0xa5cc
#define	chrKRGreekCapital_NU								0xa5cd
#define	chrKRGreekCapital_XI								0xa5ce
#define	chrKRGreekCapital_OMICRON							0xa5cf
#define	chrKRGreekCapital_PI								0xa5d0
#define	chrKRGreekCapital_RHO								0xa5d1
#define	chrKRGreekCapital_SIGMA								0xa5d2
#define	chrKRGreekCapital_TAU								0xa5d3
#define	chrKRGreekCapital_UPSILON							0xa5d4
#define	chrKRGreekCapital_PHI								0xa5d5
#define	chrKRGreekCapital_CHI								0xa5d6
#define	chrKRGreekCapital_PSI								0xa5d7
#define	chrKRGreekCapital_OMEGA								0xa5d8
#define	chrKRGreekSmall_ALPHA								0xa5e1
#define	chrKRGreekSmall_BETA								0xa5e2
#define	chrKRGreekSmall_GAMMA								0xa5e3
#define	chrKRGreekSmall_DELTA								0xa5e4
#define	chrKRGreekSmall_EPSILON								0xa5e5
#define	chrKRGreekSmall_ZETA								0xa5e6
#define	chrKRGreekSmall_ETA									0xa5e7
#define	chrKRGreekSmall_THETA								0xa5e8
#define	chrKRGreekSmall_IOTA								0xa5e9
#define	chrKRGreekSmall_KAPPA								0xa5ea
#define	chrKRGreekSmall_LAMDA								0xa5eb
#define	chrKRGreekSmall_MU									0xa5ec
#define	chrKRGreekSmall_NU									0xa5ed
#define	chrKRGreekSmall_XI									0xa5ee
#define	chrKRGreekSmall_OMICRON								0xa5ef
#define	chrKRGreekSmall_PI									0xa5f0
#define	chrKRGreekSmall_RHO									0xa5f1
#define	chrKRGreekSmall_SIGMA								0xa5f2
#define	chrKRGreekSmall_TAU									0xa5f3
#define	chrKRGreekSmall_UPSILON								0xa5f4
#define	chrKRGreekSmall_PHI									0xa5f5
#define	chrKRGreekSmall_CHI									0xa5f6
#define	chrKRGreekSmall_PSI									0xa5f7
#define	chrKRGreekSmall_OMEGA								0xa5f8
#define	chrKRBoxDrawingsLightHorizontal						0xa6a1
#define	chrKRBoxDrawingsLightVertical						0xa6a2
#define	chrKRBoxDrawingsLightDownAndRight					0xa6a3
#define	chrKRBoxDrawingsLightDownAndLeft					0xa6a4
#define	chrKRBoxDrawingsLightUpAndLeft						0xa6a5
#define	chrKRBoxDrawingsLightUpAndRight						0xa6a6
#define	chrKRBoxDrawingsLightVerticalAndRight				0xa6a7
#define	chrKRBoxDrawingsLightDownAndHorizontal				0xa6a8
#define	chrKRBoxDrawingsLightVerticalAndLeft				0xa6a9
#define	chrKRBoxDrawingsLightUpAndHorizontal				0xa6aa
#define	chrKRBoxDrawingsLightVerticalAndHorizontal			0xa6ab
#define	chrKRBoxDrawingsHeavyHorizontal						0xa6ac
#define	chrKRBoxDrawingsHeavyVertical						0xa6ad
#define	chrKRBoxDrawingsHeavyDownAndRight					0xa6ae
#define	chrKRBoxDrawingsHeavyDownAndLeft					0xa6af
#define	chrKRBoxDrawingsHeavyUpAndLeft						0xa6b0
#define	chrKRBoxDrawingsHeavyUpAndRight						0xa6b1
#define	chrKRBoxDrawingsHeavyVerticalAndRight				0xa6b2
#define	chrKRBoxDrawingsHeavyDownAndHorizontal				0xa6b3
#define	chrKRBoxDrawingsHeavyVerticalAndLeft				0xa6b4
#define	chrKRBoxDrawingsHeavyUpAndHorizontal				0xa6b5
#define	chrKRBoxDrawingsHeavyVerticalAndHorizontal			0xa6b6
#define	chrKRBoxDrawingsVerticalHeavyAndRightLight			0xa6b7
#define	chrKRBoxDrawingsDownLightAndHorizontalHeavy			0xa6b8
#define	chrKRBoxDrawingsVerticalHeavyAndLeftLight			0xa6b9
#define	chrKRBoxDrawingsUpLightAndHorizontalHeavy			0xa6ba
#define	chrKRBoxDrawingsVerticalLightAndHorizontalHeavy		0xa6bb
#define	chrKRBoxDrawingsVerticalLightAndRightHeavy			0xa6bc
#define	chrKRBoxDrawingsDownHeavyAndHorizontalLight			0xa6bd
#define	chrKRBoxDrawingsVerticalLightAndLeftHeavy			0xa6be
#define	chrKRBoxDrawingsUpHeavyAndHorizontalLight			0xa6bf
#define	chrKRBoxDrawingsVerticalHeavyAndHorizontalLight		0xa6c0
#define	chrKRBoxDrawingsDownHeavyAndLeftLight				0xa6c1
#define	chrKRBoxDrawingsDownLightAndLeftHeavy				0xa6c2
#define	chrKRBoxDrawingsUpHeavyAndLeftLight					0xa6c3
#define	chrKRBoxDrawingsUpLightAndLeftHeavy					0xa6c4
#define	chrKRBoxDrawingsUpHeavyAndRightLight				0xa6c5
#define	chrKRBoxDrawingsUpLightAndRightHeavy				0xa6c6
#define	chrKRBoxDrawingsDownHeavyAndRightLight				0xa6c7
#define	chrKRBoxDrawingsDownLightAndRightHeavy				0xa6c8
#define	chrKRBoxDrawingsUpHeavyAndRightDownLight			0xa6c9
#define	chrKRBoxDrawingsDownHeavyAndRightUpLight			0xa6ca
#define	chrKRBoxDrawingsDownLightAndRightUpHeavy			0xa6cb
#define	chrKRBoxDrawingsUpLightAndRightDownHeavy			0xa6cc
#define	chrKRBoxDrawingsUpHeavyAndLeftDownLight				0xa6cd
#define	chrKRBoxDrawingsDownHeavyAndLeftUpLight				0xa6ce
#define	chrKRBoxDrawingsDownLightAndLeftUpHeavy				0xa6cf
#define	chrKRBoxDrawingsUpLightAndLeftDownHeavy				0xa6d0
#define	chrKRBoxDrawingsLeftHeavyAndRightDownLight			0xa6d1
#define	chrKRBoxDrawingsRightHeavyAndLeftDownLight			0xa6d2
#define	chrKRBoxDrawingsRightLightAndLeftDownHeavy			0xa6d3
#define	chrKRBoxDrawingsLeftLightAndRightDownHeavy			0xa6d4
#define	chrKRBoxDrawingsLeftHeavyAndRightUpLight			0xa6d5
#define	chrKRBoxDrawingsRightHeavyAndLeftUpLight			0xa6d6
#define	chrKRBoxDrawingsRightLightAndLeftUpHeavy			0xa6d7
#define	chrKRBoxDrawingsLeftLightAndRightUpHeavy			0xa6d8
#define	chrKRBoxDrawingsLeftHeavyAndRightVerticalLight		0xa6d9
#define	chrKRBoxDrawingsRightHeavyAndLeftVerticalLight		0xa6da
#define	chrKRBoxDrawingsUpHeavyAndDownHorizontalLight		0xa6db
#define	chrKRBoxDrawingsDownHeavyAndUpHorizontalLight		0xa6dc
#define	chrKRBoxDrawingsLeftUpHeavyAndRightDownLight		0xa6dd
#define	chrKRBoxDrawingsRightUpHeavyAndLeftDownLight		0xa6de
#define	chrKRBoxDrawingsLeftDownHeavyAndRightUpLight		0xa6df
#define	chrKRBoxDrawingsRightDownHeavyAndLeftUpLight		0xa6e0
#define	chrKRBoxDrawingsDownLightAndUpHorizontalHeavy		0xa6e1
#define	chrKRBoxDrawingsUpLightAndDownHorizontalHeavy		0xa6e2
#define	chrKRBoxDrawingsRightLightAndLeftVerticalHeavy		0xa6e3
#define	chrKRBoxDrawingsLeftLightAndRightVerticalHeavy		0xa6e4
#define	chrKRSquareMuL										0xa7a1
#define	chrKRSquareMl										0xa7a2
#define	chrKRSquareDl										0xa7a3
#define	chrKRScriptSmallL									0xa7a4
#define	chrKRSquareKl										0xa7a5
#define	chrKRSquareCc										0xa7a6
#define	chrKRSquareMmCubed									0xa7a7
#define	chrKRSquareCmCubed									0xa7a8
#define	chrKRSquareMCubed									0xa7a9
#define	chrKRSquareKmCubed									0xa7aa
#define	chrKRSquareFm										0xa7ab
#define	chrKRSquareNm										0xa7ac
#define	chrKRSquareMuM										0xa7ad
#define	chrKRSquareMm										0xa7ae
#define	chrKRSquareCm										0xa7af
#define	chrKRSquareKm										0xa7b0
#define	chrKRSquareMmSquared								0xa7b1
#define	chrKRSquareCmSquared								0xa7b2
#define	chrKRSquareMSquared									0xa7b3
#define	chrKRSquareKmSquared								0xa7b4
#define	chrKRSquareHa										0xa7b5
#define	chrKRSquareMuG										0xa7b6
#define	chrKRSquareMg										0xa7b7
#define	chrKRSquareKg										0xa7b8
#define	chrKRSquareKt										0xa7b9
#define	chrKRSquareCal										0xa7ba
#define	chrKRSquareKcal										0xa7bb
#define	chrKRSquareDb										0xa7bc
#define	chrKRSquareMOverS									0xa7bd
#define	chrKRSquareMOverSSquared							0xa7be
#define	chrKRSquarePs										0xa7bf
#define	chrKRSquareNs										0xa7c0
#define	chrKRSquareMuS										0xa7c1
#define	chrKRSquareMs										0xa7c2
#define	chrKRSquarePv										0xa7c3
#define	chrKRSquareNv										0xa7c4
#define	chrKRSquareMuV										0xa7c5
#define	chrKRSquareMv										0xa7c6
#define	chrKRSquareKv										0xa7c7
#define	chrKRSquareMvMega									0xa7c8
#define	chrKRSquarePaAmps									0xa7c9
#define	chrKRSquareNa										0xa7ca
#define	chrKRSquareMuA										0xa7cb
#define	chrKRSquareMa										0xa7cc
#define	chrKRSquareKa										0xa7cd
#define	chrKRSquarePw										0xa7ce
#define	chrKRSquareNw										0xa7cf
#define	chrKRSquareMuW										0xa7d0
#define	chrKRSquareMw										0xa7d1
#define	chrKRSquareKw										0xa7d2
#define	chrKRSquareMwMega									0xa7d3
#define	chrKRSquareHz										0xa7d4
#define	chrKRSquareKhz										0xa7d5
#define	chrKRSquareMhz										0xa7d6
#define	chrKRSquareGhz										0xa7d7
#define	chrKRSquareThz										0xa7d8
#define	chrKROhmSign										0xa7d9
#define	chrKRSquareKOhm										0xa7da
#define	chrKRSquareMOhm										0xa7db
#define	chrKRSquarePf										0xa7dc
#define	chrKRSquareNf										0xa7dd
#define	chrKRSquareMuF										0xa7de
#define	chrKRSquareMol										0xa7df
#define	chrKRSquareCd										0xa7e0
#define	chrKRSquareRad										0xa7e1
#define	chrKRSquareRadOverS									0xa7e2
#define	chrKRSquareRadOverSSquared							0xa7e3
#define	chrKRSquareSr										0xa7e4
#define	chrKRSquarePa										0xa7e5
#define	chrKRSquareKpa										0xa7e6
#define	chrKRSquareMpa										0xa7e7
#define	chrKRSquareGpa										0xa7e8
#define	chrKRSquareWb										0xa7e9
#define	chrKRSquareLm										0xa7ea
#define	chrKRSquareLx										0xa7eb
#define	chrKRSquareBq										0xa7ec
#define	chrKRSquareGy										0xa7ed
#define	chrKRSquareSv										0xa7ee
#define	chrKRSquareCOverKg									0xa7ef
#define	chrKRCapital_AE										0xa8a1
#define	chrKRCapital_ETH									0xa8a2
#define	chrKRFeminineOrdinalIndicator						0xa8a3
#define	chrKRCapital_H_Stroke								0xa8a4
#define	chrKRCapitalLigatureIj								0xa8a6
#define	chrKRCapital_L_MiddleDot							0xa8a8
#define	chrKRCapital_L_Stroke								0xa8a9
#define	chrKRCapital_O_Stroke								0xa8aa
#define	chrKRCapitalLigatureOe								0xa8ab
#define	chrKRMasculineOrdinalIndicator						0xa8ac
#define	chrKRCapital_THORN									0xa8ad
#define	chrKRCapital_T_Stroke								0xa8ae
#define	chrKRCapital_ENG									0xa8af
#define	chrKRCircledSmall_A									0xa8cd
#define	chrKRCircledSmall_B									0xa8ce
#define	chrKRCircledSmall_C									0xa8cf
#define	chrKRCircledSmall_D									0xa8d0
#define	chrKRCircledSmall_E									0xa8d1
#define	chrKRCircledSmall_F									0xa8d2
#define	chrKRCircledSmall_G									0xa8d3
#define	chrKRCircledSmall_H									0xa8d4
#define	chrKRCircledSmall_I									0xa8d5
#define	chrKRCircledSmall_J									0xa8d6
#define	chrKRCircledSmall_K									0xa8d7
#define	chrKRCircledSmall_L									0xa8d8
#define	chrKRCircledSmall_M									0xa8d9
#define	chrKRCircledSmall_N									0xa8da
#define	chrKRCircledSmall_O									0xa8db
#define	chrKRCircledSmall_P									0xa8dc
#define	chrKRCircledSmall_Q									0xa8dd
#define	chrKRCircledSmall_R									0xa8de
#define	chrKRCircledSmall_S									0xa8df
#define	chrKRCircledSmall_T									0xa8e0
#define	chrKRCircledSmall_U									0xa8e1
#define	chrKRCircledSmall_V									0xa8e2
#define	chrKRCircledSmall_W									0xa8e3
#define	chrKRCircledSmall_X									0xa8e4
#define	chrKRCircledSmall_Y									0xa8e5
#define	chrKRCircledSmall_Z									0xa8e6
#define	chrKRCircledDigitOne								0xa8e7
#define	chrKRCircledDigitTwo								0xa8e8
#define	chrKRCircledDigitThree								0xa8e9
#define	chrKRCircledDigitFour								0xa8ea
#define	chrKRCircledDigitFive								0xa8eb
#define	chrKRCircledDigitSix								0xa8ec
#define	chrKRCircledDigitSeven								0xa8ed
#define	chrKRCircledDigitEight								0xa8ee
#define	chrKRCircledDigitNine								0xa8ef
#define	chrKRCircledNumberTen								0xa8f0
#define	chrKRCircledNumberEleven							0xa8f1
#define	chrKRCircledNumberTwelve							0xa8f2
#define	chrKRCircledNumberThirteen							0xa8f3
#define	chrKRCircledNumberFourteen							0xa8f4
#define	chrKRCircledNumberFifteen							0xa8f5
#define	chrKRVulgarFractionOneHalf							0xa8f6
#define	chrKRVulgarFractionOneThird							0xa8f7
#define	chrKRVulgarFractionTwoThirds						0xa8f8
#define	chrKRVulgarFractionOneQuarter						0xa8f9
#define	chrKRVulgarFractionThreeQuarters					0xa8fa
#define	chrKRVulgarFractionOneEighth						0xa8fb
#define	chrKRVulgarFractionThreeEighths						0xa8fc
#define	chrKRVulgarFractionFiveEighths						0xa8fd
#define	chrKRVulgarFractionSevenEighths						0xa8fe
#define	chrKRSmall_AE										0xa9a1
#define	chrKRSmall_D_Stroke									0xa9a2
#define	chrKRSmall_ETH										0xa9a3
#define	chrKRSmall_H_Stroke									0xa9a4
#define	chrKRSmallDotless_I									0xa9a5
#define	chrKRSmallLigatureIj								0xa9a6
#define	chrKRSmall_KRA										0xa9a7
#define	chrKRSmall_L_MiddleDot								0xa9a8
#define	chrKRSmall_L_Stroke									0xa9a9
#define	chrKRSmall_O_Stroke									0xa9aa
#define	chrKRSmallLigatureOe								0xa9ab
#define	chrKRSmallSharp_S									0xa9ac
#define	chrKRSmall_THORN									0xa9ad
#define	chrKRSmall_T_Stroke									0xa9ae
#define	chrKRSmall_ENG										0xa9af
#define	chrKRSmallNPrecededByApostrophe						0xa9b0
#define	chrKRParenthesizedSmall_A							0xa9cd
#define	chrKRParenthesizedSmall_B							0xa9ce
#define	chrKRParenthesizedSmall_C							0xa9cf
#define	chrKRParenthesizedSmall_D							0xa9d0
#define	chrKRParenthesizedSmall_E							0xa9d1
#define	chrKRParenthesizedSmall_F							0xa9d2
#define	chrKRParenthesizedSmall_G							0xa9d3
#define	chrKRParenthesizedSmall_H							0xa9d4
#define	chrKRParenthesizedSmall_I							0xa9d5
#define	chrKRParenthesizedSmall_J							0xa9d6
#define	chrKRParenthesizedSmall_K							0xa9d7
#define	chrKRParenthesizedSmall_L							0xa9d8
#define	chrKRParenthesizedSmall_M							0xa9d9
#define	chrKRParenthesizedSmall_N							0xa9da
#define	chrKRParenthesizedSmall_O							0xa9db
#define	chrKRParenthesizedSmall_P							0xa9dc
#define	chrKRParenthesizedSmall_Q							0xa9dd
#define	chrKRParenthesizedSmall_R							0xa9de
#define	chrKRParenthesizedSmall_S							0xa9df
#define	chrKRParenthesizedSmall_T							0xa9e0
#define	chrKRParenthesizedSmall_U							0xa9e1
#define	chrKRParenthesizedSmall_V							0xa9e2
#define	chrKRParenthesizedSmall_W							0xa9e3
#define	chrKRParenthesizedSmall_X							0xa9e4
#define	chrKRParenthesizedSmall_Y							0xa9e5
#define	chrKRParenthesizedSmall_Z							0xa9e6
#define	chrKRParenthesizedDigitOne							0xa9e7
#define	chrKRParenthesizedDigitTwo							0xa9e8
#define	chrKRParenthesizedDigitThree						0xa9e9
#define	chrKRParenthesizedDigitFour							0xa9ea
#define	chrKRParenthesizedDigitFive							0xa9eb
#define	chrKRParenthesizedDigitSix							0xa9ec
#define	chrKRParenthesizedDigitSeven						0xa9ed
#define	chrKRParenthesizedDigitEight						0xa9ee
#define	chrKRParenthesizedDigitNine							0xa9ef
#define	chrKRParenthesizedNumberTen							0xa9f0
#define	chrKRParenthesizedNumberEleven						0xa9f1
#define	chrKRParenthesizedNumberTwelve						0xa9f2
#define	chrKRParenthesizedNumberThirteen					0xa9f3
#define	chrKRParenthesizedNumberFourteen					0xa9f4
#define	chrKRParenthesizedNumberFifteen						0xa9f5
#define	chrKRSuperscriptOne									0xa9f6
#define	chrKRSuperscriptTwo									0xa9f7
#define	chrKRSuperscriptThree								0xa9f8
#define	chrKRSuperscriptFour								0xa9f9
#define	chrKRSuperscriptSmall_N								0xa9fa
#define	chrKRSubscriptOne									0xa9fb
#define	chrKRSubscriptTwo									0xa9fc
#define	chrKRSubscriptThree									0xa9fd
#define	chrKRSubscriptFour									0xa9fe
#define	chrKRHiraganaSmall_A								0xaaa1
#define	chrKRHiragana_A										0xaaa2
#define	chrKRHiraganaSmall_I								0xaaa3
#define	chrKRHiragana_I										0xaaa4
#define	chrKRHiraganaSmall_U								0xaaa5
#define	chrKRHiragana_U										0xaaa6
#define	chrKRHiraganaSmall_E								0xaaa7
#define	chrKRHiragana_E										0xaaa8
#define	chrKRHiraganaSmall_O								0xaaa9
#define	chrKRHiragana_O										0xaaaa
#define	chrKRHiragana_KA									0xaaab
#define	chrKRHiragana_GA									0xaaac
#define	chrKRHiragana_KI									0xaaad
#define	chrKRHiragana_GI									0xaaae
#define	chrKRHiragana_KU									0xaaaf
#define	chrKRHiragana_GU									0xaab0
#define	chrKRHiragana_KE									0xaab1
#define	chrKRHiragana_GE									0xaab2
#define	chrKRHiragana_KO									0xaab3
#define	chrKRHiragana_GO									0xaab4
#define	chrKRHiragana_SA									0xaab5
#define	chrKRHiragana_ZA									0xaab6
#define	chrKRHiragana_SI									0xaab7
#define	chrKRHiragana_ZI									0xaab8
#define	chrKRHiragana_SU									0xaab9
#define	chrKRHiragana_ZU									0xaaba
#define	chrKRHiragana_SE									0xaabb
#define	chrKRHiragana_ZE									0xaabc
#define	chrKRHiragana_SO									0xaabd
#define	chrKRHiragana_ZO									0xaabe
#define	chrKRHiragana_TA									0xaabf
#define	chrKRHiragana_DA									0xaac0
#define	chrKRHiragana_TI									0xaac1
#define	chrKRHiragana_DI									0xaac2
#define	chrKRHiraganaSmall_TU								0xaac3
#define	chrKRHiragana_TU									0xaac4
#define	chrKRHiragana_DU									0xaac5
#define	chrKRHiragana_TE									0xaac6
#define	chrKRHiragana_DE									0xaac7
#define	chrKRHiragana_TO									0xaac8
#define	chrKRHiragana_DO									0xaac9
#define	chrKRHiragana_NA									0xaaca
#define	chrKRHiragana_NI									0xaacb
#define	chrKRHiragana_NU									0xaacc
#define	chrKRHiragana_NE									0xaacd
#define	chrKRHiragana_NO									0xaace
#define	chrKRHiragana_HA									0xaacf
#define	chrKRHiragana_BA									0xaad0
#define	chrKRHiragana_PA									0xaad1
#define	chrKRHiragana_HI									0xaad2
#define	chrKRHiragana_BI									0xaad3
#define	chrKRHiragana_PI									0xaad4
#define	chrKRHiragana_HU									0xaad5
#define	chrKRHiragana_BU									0xaad6
#define	chrKRHiragana_PU									0xaad7
#define	chrKRHiragana_HE									0xaad8
#define	chrKRHiragana_BE									0xaad9
#define	chrKRHiragana_PE									0xaada
#define	chrKRHiragana_HO									0xaadb
#define	chrKRHiragana_BO									0xaadc
#define	chrKRHiragana_PO									0xaadd
#define	chrKRHiragana_MA									0xaade
#define	chrKRHiragana_MI									0xaadf
#define	chrKRHiragana_MU									0xaae0
#define	chrKRHiragana_ME									0xaae1
#define	chrKRHiragana_MO									0xaae2
#define	chrKRHiraganaSmall_YA								0xaae3
#define	chrKRHiragana_YA									0xaae4
#define	chrKRHiraganaSmall_YU								0xaae5
#define	chrKRHiragana_YU									0xaae6
#define	chrKRHiraganaSmall_YO								0xaae7
#define	chrKRHiragana_YO									0xaae8
#define	chrKRHiragana_RA									0xaae9
#define	chrKRHiragana_RI									0xaaea
#define	chrKRHiragana_RU									0xaaeb
#define	chrKRHiragana_RE									0xaaec
#define	chrKRHiragana_RO									0xaaed
#define	chrKRHiraganaSmall_WA								0xaaee
#define	chrKRHiragana_WA									0xaaef
#define	chrKRHiragana_WI									0xaaf0
#define	chrKRHiragana_WE									0xaaf1
#define	chrKRHiragana_WO									0xaaf2
#define	chrKRHiragana_N										0xaaf3
#define	chrKRKatakanaSmall_A								0xaba1
#define	chrKRKatakana_A										0xaba2
#define	chrKRKatakanaSmall_I								0xaba3
#define	chrKRKatakana_I										0xaba4
#define	chrKRKatakanaSmall_U								0xaba5
#define	chrKRKatakana_U										0xaba6
#define	chrKRKatakanaSmall_E								0xaba7
#define	chrKRKatakana_E										0xaba8
#define	chrKRKatakanaSmall_O								0xaba9
#define	chrKRKatakana_O										0xabaa
#define	chrKRKatakana_KA									0xabab
#define	chrKRKatakana_GA									0xabac
#define	chrKRKatakana_KI									0xabad
#define	chrKRKatakana_GI									0xabae
#define	chrKRKatakana_KU									0xabaf
#define	chrKRKatakana_GU									0xabb0
#define	chrKRKatakana_KE									0xabb1
#define	chrKRKatakana_GE									0xabb2
#define	chrKRKatakana_KO									0xabb3
#define	chrKRKatakana_GO									0xabb4
#define	chrKRKatakana_SA									0xabb5
#define	chrKRKatakana_ZA									0xabb6
#define	chrKRKatakana_SI									0xabb7
#define	chrKRKatakana_ZI									0xabb8
#define	chrKRKatakana_SU									0xabb9
#define	chrKRKatakana_ZU									0xabba
#define	chrKRKatakana_SE									0xabbb
#define	chrKRKatakana_ZE									0xabbc
#define	chrKRKatakana_SO									0xabbd
#define	chrKRKatakana_ZO									0xabbe
#define	chrKRKatakana_TA									0xabbf
#define	chrKRKatakana_DA									0xabc0
#define	chrKRKatakana_TI									0xabc1
#define	chrKRKatakana_DI									0xabc2
#define	chrKRKatakanaSmall_TU								0xabc3
#define	chrKRKatakana_TU									0xabc4
#define	chrKRKatakana_DU									0xabc5
#define	chrKRKatakana_TE									0xabc6
#define	chrKRKatakana_DE									0xabc7
#define	chrKRKatakana_TO									0xabc8
#define	chrKRKatakana_DO									0xabc9
#define	chrKRKatakana_NA									0xabca
#define	chrKRKatakana_NI									0xabcb
#define	chrKRKatakana_NU									0xabcc
#define	chrKRKatakana_NE									0xabcd
#define	chrKRKatakana_NO									0xabce
#define	chrKRKatakana_HA									0xabcf
#define	chrKRKatakana_BA									0xabd0
#define	chrKRKatakana_PA									0xabd1
#define	chrKRKatakana_HI									0xabd2
#define	chrKRKatakana_BI									0xabd3
#define	chrKRKatakana_PI									0xabd4
#define	chrKRKatakana_HU									0xabd5
#define	chrKRKatakana_BU									0xabd6
#define	chrKRKatakana_PU									0xabd7
#define	chrKRKatakana_HE									0xabd8
#define	chrKRKatakana_BE									0xabd9
#define	chrKRKatakana_PE									0xabda
#define	chrKRKatakana_HO									0xabdb
#define	chrKRKatakana_BO									0xabdc
#define	chrKRKatakana_PO									0xabdd
#define	chrKRKatakana_MA									0xabde
#define	chrKRKatakana_MI									0xabdf
#define	chrKRKatakana_MU									0xabe0
#define	chrKRKatakana_ME									0xabe1
#define	chrKRKatakana_MO									0xabe2
#define	chrKRKatakanaSmall_YA								0xabe3
#define	chrKRKatakana_YA									0xabe4
#define	chrKRKatakanaSmall_YU								0xabe5
#define	chrKRKatakana_YU									0xabe6
#define	chrKRKatakanaSmall_YO								0xabe7
#define	chrKRKatakana_YO									0xabe8
#define	chrKRKatakana_RA									0xabe9
#define	chrKRKatakana_RI									0xabea
#define	chrKRKatakana_RU									0xabeb
#define	chrKRKatakana_RE									0xabec
#define	chrKRKatakana_RO									0xabed
#define	chrKRKatakanaSmall_WA								0xabee
#define	chrKRKatakana_WA									0xabef
#define	chrKRKatakana_WI									0xabf0
#define	chrKRKatakana_WE									0xabf1
#define	chrKRKatakana_WO									0xabf2
#define	chrKRKatakana_N										0xabf3
#define	chrKRKatakana_VU									0xabf4
#define	chrKRKatakanaSmall_KA								0xabf5
#define	chrKRKatakanaSmall_KE								0xabf6
#define	chrKRCyrillicCapital_A								0xaca1
#define	chrKRCyrillicCapital_BE								0xaca2
#define	chrKRCyrillicCapital_VE								0xaca3
#define	chrKRCyrillicCapital_GHE							0xaca4
#define	chrKRCyrillicCapital_DE								0xaca5
#define	chrKRCyrillicCapital_IE								0xaca6
#define	chrKRCyrillicCapital_IO								0xaca7
#define	chrKRCyrillicCapital_ZHE							0xaca8
#define	chrKRCyrillicCapital_ZE								0xaca9
#define	chrKRCyrillicCapital_I								0xacaa
#define	chrKRCyrillicCapitalShort_I							0xacab
#define	chrKRCyrillicCapital_KA								0xacac
#define	chrKRCyrillicCapital_EL								0xacad
#define	chrKRCyrillicCapital_EM								0xacae
#define	chrKRCyrillicCapital_EN								0xacaf
#define	chrKRCyrillicCapital_O								0xacb0
#define	chrKRCyrillicCapital_PE								0xacb1
#define	chrKRCyrillicCapital_ER								0xacb2
#define	chrKRCyrillicCapital_ES								0xacb3
#define	chrKRCyrillicCapital_TE								0xacb4
#define	chrKRCyrillicCapital_U								0xacb5
#define	chrKRCyrillicCapital_EF								0xacb6
#define	chrKRCyrillicCapital_HA								0xacb7
#define	chrKRCyrillicCapital_TSE							0xacb8
#define	chrKRCyrillicCapital_CHE							0xacb9
#define	chrKRCyrillicCapital_SHA							0xacba
#define	chrKRCyrillicCapital_SHCHA							0xacbb
#define	chrKRCyrillicCapitalHardSign						0xacbc
#define	chrKRCyrillicCapital_YERU							0xacbd
#define	chrKRCyrillicCapitalSoftSign						0xacbe
#define	chrKRCyrillicCapital_E								0xacbf
#define	chrKRCyrillicCapital_YU								0xacc0
#define	chrKRCyrillicCapital_YA								0xacc1
#define	chrKRCyrillicSmall_A								0xacd1
#define	chrKRCyrillicSmall_BE								0xacd2
#define	chrKRCyrillicSmall_VE								0xacd3
#define	chrKRCyrillicSmall_GHE								0xacd4
#define	chrKRCyrillicSmall_DE								0xacd5
#define	chrKRCyrillicSmall_IE								0xacd6
#define	chrKRCyrillicSmall_IO								0xacd7
#define	chrKRCyrillicSmall_ZHE								0xacd8
#define	chrKRCyrillicSmall_ZE								0xacd9
#define	chrKRCyrillicSmall_I								0xacda
#define	chrKRCyrillicSmallShort_I							0xacdb
#define	chrKRCyrillicSmall_KA								0xacdc
#define	chrKRCyrillicSmall_EL								0xacdd
#define	chrKRCyrillicSmall_EM								0xacde
#define	chrKRCyrillicSmall_EN								0xacdf
#define	chrKRCyrillicSmall_O								0xace0
#define	chrKRCyrillicSmall_PE								0xace1
#define	chrKRCyrillicSmall_ER								0xace2
#define	chrKRCyrillicSmall_ES								0xace3
#define	chrKRCyrillicSmall_TE								0xace4
#define	chrKRCyrillicSmall_U								0xace5
#define	chrKRCyrillicSmall_EF								0xace6
#define	chrKRCyrillicSmall_HA								0xace7
#define	chrKRCyrillicSmall_TSE								0xace8
#define	chrKRCyrillicSmall_CHE								0xace9
#define	chrKRCyrillicSmall_SHA								0xacea
#define	chrKRCyrillicSmall_SHCHA							0xaceb
#define	chrKRCyrillicSmallHardSign							0xacec
#define	chrKRCyrillicSmall_YERU								0xaced
#define	chrKRCyrillicSmallSoftSign							0xacee
#define	chrKRCyrillicSmall_E								0xacef
#define	chrKRCyrillicSmall_YU								0xacf0
#define	chrKRCyrillicSmall_YA								0xacf1

#define chrKRLastDoubleByte								0xFDFE

#endif // _CHARKR_H_
